

cd "X:\OPD\Hemmeter\SBST"


set more off
cd "C:\Users\210742\Desktop\File Drop"

/*
use random_final, clear
compress
save random_final, replace
*/
use random_check0, clear

gen time_doe=2017-year(bclm_doe_start_1)
	gen time_group=.
		replace time_group=0 if time_doe<3
		replace time_group=1 if inrange(time_doe,3,5)
		replace time_group=2 if inrange(time_doe,6,10)
		replace time_group=3 if inrange(time_doe,11,15)
		replace time_group=4 if time_doe>15

destring dib_dig_1, gen(dibdig) 
gen conditions=""
	replace conditions="01 Infectious and Parasitic" /*"17 Other"*/ if inrange(dibdig,0020,0189) | inrange(dibdig,0200,0279) | inrange(dibdig,0300,0419) | ///
			inrange(dibdig,0430,0579) | inrange(dibdig,0600,0669) | inrange(dibdig,0700,0889) | inrange(dibdig,0900,1049) | ///
			inrange(dibdig,1100,1189) | inrange(dibdig,1200,1359) |  inrange(dibdig,1370,1399) | inrange(dibdig,7710,7719)
	replace conditions="02 Neoplasms" if inrange(dibdig,0420,0429) | inrange(dibdig,1400,1659) | inrange(dibdig,1700,1769) | ///
			inrange(dibdig,1780,2089) | inrange(dibdig,2100,2399)
	replace conditions="03 Endocrine" if inrange(dibdig,2400,2469) | inrange(dibdig,2500,2539) | inrange(dibdig,2550,2559) | ///
			inrange(dibdig,2600,2799)
	replace conditions="04 Blood" if inrange(dibdig,2800,2899) | inrange(dibdig,7720,7739) |  inrange(dibdig,7760,7769)
	
	replace conditions="05a Autistic Disorders" if inrange(dibdig,2990,2999) 
	replace conditions="05b Developmental disorders" if inrange(dibdig,3150,3159) 	
	replace conditions="05c Childhood and adolescent disorders not elsewhere classified" if inrange(dibdig,3120,3149) 	
	replace conditions="05d Intellectual disability" if inrange(dibdig,3170,3194) | inrange(dibdig,3196,3199) 
	replace conditions="05e Mood disorders" if inrange(dibdig,2960,2969) | inrange(dibdig,3110,3119) 
	replace conditions="05f Organic Mental Disorders" if inrange(dibdig,2900,2909)  | inrange(dibdig,2940,2949)  | inrange(dibdig,3100,3109) 	
	replace conditions="05g Schizophrenia" if inrange(dibdig,2950,2959) | inrange(dibdig,2970,2989) 	
	replace conditions="05h Other Mental disorders" if inrange(dibdig,2910,2939) | inrange(dibdig,3000,3099) | inrange(dibdig,3160,3169) | dibdig==3195
			
	replace conditions="08 Nervous System" if inrange(dibdig,3200,3269) | inrange(dibdig,3290,3379) | inrange(dibdig,3400,3749) | ///
			inrange(dibdig,3760,3899)
	replace conditions="09 Circulatory System" if inrange(dibdig,3750,3759) | inrange(dibdig,3900,3989) | inrange(dibdig,4010,4059) | ///
			inrange(dibdig,4100,4179) | inrange(dibdig,4200,4389) | inrange(dibdig,4400,4449) | inrange(dibdig,4460,4489) | ///
			inrange(dibdig,4510,4599)
	replace conditions="10 Respiratory System" if inrange(dibdig,4600,4669) | inrange(dibdig,4700,4789) | inrange(dibdig,4800,4879) | ///
			inrange(dibdig,4900,4969) | inrange(dibdig,5000,5089) | inrange(dibdig,5100,5199) | inrange(dibdig,7680,7709)
	replace conditions="11 Digestive System" if inrange(dibdig,5200,5379) | inrange(dibdig,5400,5439) | inrange(dibdig,5500,5539) | ///
			inrange(dibdig,5550,5589) | inrange(dibdig,5600,5609) | inrange(dibdig,5620,5629) | inrange(dibdig,5640,5799) | ///
			inrange(dibdig,7770,7779) 
	replace conditions="12 Genitourinary System" if inrange(dibdig,5800,6089) | inrange(dibdig,6100,6119) | inrange(dibdig,6140,6299)
	replace conditions="13 Skin" /*"17 Other"*/ if inrange(dibdig,6800,6869) | inrange(dibdig,6900,6989) | inrange(dibdig,7000,7099) | ///
			inrange(dibdig,7780,7789)
	replace conditions="14 Musculoskeletal" if inrange(dibdig,7100,7399)
	replace conditions="15 Congenital Anomalies" /*"17 Other"*/ if inrange(dibdig,7400,7599)
	replace conditions="16 Injuries" if inrange(dibdig,8000,8489) | inrange(dibdig,8500,8549) | inrange(dibdig,8600,8879) | ///
			inrange(dibdig,8900,8979) | inrange(dibdig,9000,9059) | inrange(dibdig,9070,9099) | inrange(dibdig,9200,9299) | ///
			inrange(dibdig,9400,9599)
	replace conditions="17 Other" if inrange(dibdig,7600,7609) | inrange(dibdig,7640,7669) | inrange(dibdig,7800,7809) | ///
			inrange(dibdig,7830,7849) | dibdig==9330
	replace conditions="18 Unknown" if dibdig==. | inrange(dibdig,0,0019) | inrange(dibdig,0190,0199) | inrange(dibdig,0280,0299) | ///
			inrange(dibdig,0580,0599) | inrange(dibdig,0670,0699) | inrange(dibdig,0890,0899) | inrange(dibdig,1050,1099) | ///
			inrange(dibdig,1190,1199) | inrange(dibdig,1360,1369) | inrange(dibdig,1660,1699) | inrange(dibdig,1770,1779) | ///
			inrange(dibdig,2090,2099) | inrange(dibdig,2470,2499) | inrange(dibdig,2540,2549) | inrange(dibdig,2560,2599) | ///
			inrange(dibdig,3270,3289) | inrange(dibdig,3380,3399) | ///
			inrange(dibdig,3990,4009) | inrange(dibdig,4060,4099) | inrange(dibdig,4180,4199) | inrange(dibdig,4390,4399) | ///
			inrange(dibdig,4450,4459) | inrange(dibdig,4490,4509) | inrange(dibdig,4670,4699) | inrange(dibdig,4790,4799) | ///
			inrange(dibdig,4880,4899) | inrange(dibdig,4970,4999) | inrange(dibdig,5090,5099) | inrange(dibdig,5380,5399) | ///
			inrange(dibdig,5440,5499) | inrange(dibdig,5540,5549) | inrange(dibdig,5590,5599) | inrange(dibdig,5610,5619) | ///
			inrange(dibdig,5630,5639) | inrange(dibdig,6090,6099) | inrange(dibdig,6120,6139) | inrange(dibdig,6300,6799) | ///
			inrange(dibdig,6870,6899) | inrange(dibdig,6990,6999) | inrange(dibdig,7610,7639) | inrange(dibdig,7670,7679) | ///
			inrange(dibdig,7790,7799) | inrange(dibdig,7810,7829) | inrange(dibdig,7850,7999) | inrange(dibdig,8490,8499) | ///
			inrange(dibdig,8550,8599) | inrange(dibdig,8880,8899) | inrange(dibdig,8980,8999) | inrange(dibdig,9060,9069) | ///
			inrange(dibdig,9100,9199) | inrange(dibdig,9300,9329) | inrange(dibdig,9331,9399) | inrange(dibdig,9600,9999) | ///
			dibdig==7740
	/*Make them numeric and label them*/
		encode conditions, gen(disab1)

gen race=racep
	replace race="M" if racep==""
	
gen reduc=erreduc
	replace reduc=2 if erreduc==.
	
gen hibasis=hi_basis
	replace hibasis="M" if hi_basis==""
		/*See http://policynet.ba.ssa.gov/poms.nsf/lnx/0800850315
		A=Age 65
		B=Disability
		E=End-Stage Renal
		H=Environmental Health Hazard
		W=Working Disabled Individual*/
		
	
gen smibasis=smi_basis
	replace smibasis="M" if smi_basis==""	
	/*see http://policynet.ba.ssa.gov/poms.nsf/lnx/0800850125 same as above*/
	
gen dual=dual_type
	replace dual="NA" if dual_type==""
	
gen dual_binary=(dual~="NA")

gen dual_group=0
	replace dual_group=1 if substr(dual,1,1)=="D"
	replace dual_group=2 if substr(dual,1,1)=="R"

gen med_stat=medstat
	replace med_stat="M" if medstat==""
	/*medstat=A: Medicare active*/
	
gen redage=red_for_age
	replace redage="N" if red_for_age==""
	

gen anyletter=(treatment~=0)
gen male=(sexb=="M")
encode addr_state, gen(state)


gen potentialssi=735+20-mba

*gen prior=inlist(sisc,"B","L","N","T","U","V","W","X")
 *replace prior=1 if inlist(sisc,"I","P")
gen prior=inlist(prior_ssi_status,2,3,4)


/*
foreach x of varlist bic_a age bic addr_state sexb race reduc hibasis hi_active smibasis smi_active nctzn ///
	dual_group dual_binary reppayee med_stat redage time_group disab1 {
	tab `x' treatment, missing chi2
}
foreach x of varlist bic_a age bic addr_state sexb race reduc hibasis hi_active smibasis smi_active nctzn ///
	dual_group dual_binary reppayee med_stat redage time_group disab1 {
	reg treatment i.`x'
} 
*/

/*
foreach x of varlist totben comben potential_pia {
	reg `x' i.treatment
}

reg treatment i.bic_a i.age i.addr_state i.sexb i.race i.hibasis i.smibasis i.dual_group i.reppayee i.redage i.time_group i.disab1, robust
*/
	/*
capture erase validation.xml
capture erase validation.txt

reg anyletter age male potentialssi i.prior i.state, cluster(state)
outreg2 using validation, ctitle(any) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 
	
reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,1), cluster(state)
outreg2 using validation, ctitle(treat1) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 

reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,2), cluster(state)
outreg2 using validation, ctitle(treat2) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 
	
reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,3), cluster(state)
outreg2 using validation, ctitle(treat3) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 
	
reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,4), cluster(state)
outreg2 using validation, ctitle(treat4) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 

reg anyletter age male potentialssi i.prior i.state
outreg2 using validation, ctitle(any) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 
	
reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,1)
outreg2 using validation, ctitle(treat1) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 

reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,2)
outreg2 using validation, ctitle(treat2) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 
	
reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,3)
outreg2 using validation, ctitle(treat3) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 
	
reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,4)
outreg2 using validation, ctitle(treat4) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 
	
reg anyletter age male potentialssi i.prior i.state, robust
outreg2 using validation, ctitle(any) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 
	
reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,1), robust
outreg2 using validation, ctitle(treat1) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 

reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,2), robust
outreg2 using validation, ctitle(treat2) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 
	
reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,3), robust
outreg2 using validation, ctitle(treat3) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 
	
reg anyletter age male potentialssi i.prior i.state if inlist(treatment,0,4), robust
outreg2 using validation, ctitle(treat4) bdec(4) sdec(4) cdec(4) excel wide
	testparm age male potentialssi i.prior i.state 
	*/
	/*alternate check for balance*/
	
capture mat drop pval_0
	
foreach x of varlist age potentialssi {
	ttest `x', by(anyletter)
	mat pval_0=(nullmat(pval_0)\r(p))
}
foreach x of varlist male prior {
	prtest `x', by(anyletter)
	mat pval_0=(nullmat(pval_0)\r(p))
}
tab state anyletter, chi	
	mat pval_0=(nullmat(pval_0)\r(p))

forvalues i=1(1)4 {

	capture mat drop pval_`i'

	foreach x of varlist age potentialssi {
		ttest `x' if inlist(treatment,0,`i'), by(treatment)
		mat pval_`i'=(nullmat(pval_`i')\r(p))
	}
	foreach x of varlist male prior {
		prtest `x' if inlist(treatment,0,`i'), by(treatment)
		mat pval_`i'=(nullmat(pval_`i')\r(p))
	}
	tab state treatment if inlist(treatment,0,`i'), chi col
		mat pval_`i'=(nullmat(pval_`i')\r(p))
		
}
	/**/
	
mat p=(pval_0,pval_1,pval_2,pval_3,pval_4)
mat list p
